
/*:

@target MZ
@plugindesc セーブデータを一つにします。
@author メロウ紙芝居
@url https://meroukamisibai.com/

@help MK_OneSaveData.js

このプラグインを使うとタイトル画面のコンティニューが消えます。
ニューゲームを押した時にファイル1にセーブデータが存在する場合は
勝手にファイル1をロードします。


@command save
@text セーブ
@desc ファイル1にセーブします。

@command title
@text セーブしてタイトル画面
@desc ファイル1にセーブしてタイトル画面に戻ります。

*/

(() => {
    
    /////////////////プラグイン関係/////////////////
    
    const pluginName = "MK_OneSaveData";
    
    //----------プラグインコマンド----------

    //セーブ
    PluginManager.registerCommand(pluginName, "save", args => {
        MK_Save();
    });
    
    //セーブしてタイトル画面
    PluginManager.registerCommand(pluginName, "title", args => {
        MK_Save();
        SceneManager.goto(Scene_Title);
    });
    
    //セーブ
    MK_Save = function(){
        $gameMap._interpreter._index++;//実行中イベントコマンドの位置ずらして保存
        $gameSystem.onBeforeSave();
        
        DataManager.saveGame(1)//ファイル1にセーブ
            .then(() => SoundManager.playSave())
            .catch(() => SoundManager.playBuzzer());
        
        $gameMap._interpreter._index--;//戻す
    };
    
    
    /////////////////元々オブジェクト/////////////////
    
    //----------タイトルシーン----------
    
    //ニューゲーム押したとき
    const _Scene_Title_commandNewGame = Scene_Title.prototype.commandNewGame;
    Scene_Title.prototype.commandNewGame = function() {
        DataManager.loadGame(1)//セーブデータ1読み込む
            //読み込み成功
            .then(() => {
                this._commandWindow.close();
                this.fadeOutAll();
                this.MK_OneSaveData_ReloadMapIfUpdated();//マップがアップデートされてたらアップデート
                SceneManager.goto(Scene_Map);
                this._loadSuccess = true;
            })
            //読み込めなければニューゲーム
            .catch(() => _Scene_Title_commandNewGame.apply(this, arguments));
    };
    
    //Scene_LoadのreloadMapIfUpdatedコピペ マップがアップデートされてたらアップデート
    Scene_Title.prototype.MK_OneSaveData_ReloadMapIfUpdated = function() {
        if ($gameSystem.versionId() !== $dataSystem.versionId) {
            const mapId = $gameMap.mapId();
            const x = $gamePlayer.x;
            const y = $gamePlayer.y;
            $gamePlayer.reserveTransfer(mapId, x, y);
            $gamePlayer.requestMapReload();
        }
    };
    
    //シーン終了時
    const _Scene_Title_terminate = Scene_Title.prototype.terminate;
    Scene_Title.prototype.terminate = function() {
        _Scene_Title_terminate.apply(this, arguments);
        if (this._loadSuccess) {
            $gameSystem.onAfterLoad();
        }
    };
    
    //----------マップシーン----------
    
    //フェードインするシーン
    const _Scene_Map_needsFadeIn = Scene_Map.prototype.needsFadeIn;
    Scene_Map.prototype.needsFadeIn = function() {
        return (_Scene_Map_needsFadeIn.apply(this, arguments) || SceneManager.isPreviousScene(Scene_Title));
    };
    
    //----------タイトルウィンドウ----------
    
    //選択肢
    const _Window_TitleCommand_makeCommandList = Window_TitleCommand.prototype.makeCommandList;
    Window_TitleCommand.prototype.makeCommandList = function() {
        _Window_TitleCommand_makeCommandList.apply(this, arguments);
        const index = this._list.findIndex((command) => (command.symbol == "continue") ? true : false);
        if(index != -1){
            this._list.splice(index, 1);
            this.height -= this.itemHeight();
        }
    };
    
})();
